#ifndef __SNPINFO_H__
#define __SNPINFO_H__

#include "StringBasics.h"
#include "StringArray.h"
#include "LogManager.h"

#define __ASSAY_CHR_X__    88 // ascii for X
#define __ASSAY_CHR_Y__    89 // ascii for Y

#define __ASSAY_QC_NONE__        0
#define __ASSAY_QC_AUTOSOME__    1
#define __ASSAY_QC_SEXLINKED__   2

extern LogManager logMgr;

class SNPInfo
{
public:
   String   rsID;
   String   preferredID;
   String   build;
   String   sequence;
   String   source;
   String   chromosome;
   String   strand;

   char     alleles[2];

   int      position;
   int      qcType;

   SNPInfo();
   ~SNPInfo();

   bool isQCable()
   { return qcType != __ASSAY_QC_NONE__; }
   bool isSexLinked()
   { return qcType == __ASSAY_QC_SEXLINKED__; }
   bool isAutosomal()
   { return qcType == __ASSAY_QC_AUTOSOME__; }

   // Initializes alleles based on sequence, flags errors
   bool FindAlleles();
   bool AreAllelesSwitched(char *loaderAlleles, bool monomorphic);
   bool DoAllelesMatch(char * loaderAlleles, bool monomorphic);

private:
    String switchBases(char * loaderAlleles);
};

#endif
