#include "SampleLabel.h"

#include <stdio.h>

SampleLabel::SampleLabel(int individuals)
{
   // has exactly sample # of slots
   sampleLabels.Dimension(individuals);
   sampleLabels.Set(-1);
   
   failure = "";
}


bool SampleLabel::LoadSampleLabels(FILE *pedfile, String labelKey, StringArray & columnLabels, int pedCount)
{
   int cnt = -1;
   if (pedfile == NULL)
     return false;

   if (!labelKey.Compare(""))
   {
      failure.catprintf("Empty sample property label key. Ignoring sample labels");
      logMgr.WriteToLog(failure, 0);
      failure.Clear();
      return false;
   }
   
   String buffer;
   StringArray tokens;

   StringArray tempLabels;
   tempLabels.Dimension(pedCount);
   StringArray tempIds;
   tempIds.Dimension(pedCount);
   
   // this do loop goes through the pedigree file and assigns labels to the sampleIds
   do
   {
      buffer.ReadLine(pedfile);
      tokens.ReplaceTokens(buffer);
      
      if(tokens.Length() < 2)
         continue;
      /* the assumption with continuing here is that pedigree loader has 
         already warned about all the lines that were problematic */

      cnt++;
      tempIds[cnt] = tokens[1];
      tempLabels[cnt] = "NOTFOUND";
      if(tokens.Length() < 6)
	 continue;
  
      for (int i=5; i < tokens.Length(); i++)
      {
         StringArray tempTokens;
	 tempTokens.ReplaceTokens(tokens[i], "=");
	 
	 if(tempTokens[0].SlowCompare(labelKey) == 0)
	 {
            if(tempTokens.Length() != 2)
            {
	       failure.catprintf("INVALID FORMAT: Sample label not in KEY=VALUE format for sample %s", (const char *)tempIds[cnt]);
	       logMgr.WriteToLog(failure, 8);
	       failure.Clear();
            }
            else
	       tempLabels[cnt] = tempTokens[1].AsUpper();
	    break;
         }
      }
   }while(!feof(pedfile));

   for (int i = 1; i < columnLabels.Length(); i++)
   {
      tokens.ReplaceTokens(columnLabels[i], ".");
      int index = tempIds.Find(tokens[0]);
      if (index == -1)
      {
         failure.catprintf("No labels were found for sample %s", (const char *) columnLabels[i]);
	 logMgr.WriteToLog(failure, 9);
	 failure.Clear();
         continue;
      }
      else if(tempLabels[index].FastCompare("NOTFOUND") == 0)
      {
         failure.catprintf("No labels were found for sample %s", (const char *) columnLabels[i]);
	 logMgr.WriteToLog(failure, 9);
	 failure.Clear();
         continue;
      }
      String tempLabel = tempLabels[index].AsUpper();
      if (labelHash.Find(tempLabel) == -1)
      {
         labelHash.SetInteger(tempLabel, labelHash.Entries());
	 labelArray.Push(tempLabel);
      }
      sampleLabels[i-1] = labelHash.Integer(tempLabel);
      fflush(stdout);
   }

   if (sampleLabels.Sum() == -sampleLabels.Length())
   {
      failure.catprintf("WARNING: None of the samples has labels present.\n");
      failure.catprintf("WARNING: Association test cannot be performed (even if asked for).");
      logMgr.WriteToLog(failure, 0);
      failure.Clear();
      return false;
   }
   return true;
}
