#ifndef __SECONDPASS_H__
#define __SECONDPASS_H__

#include "IntArray.h"
#include "StringArray.h"
#include "StringHash.h"
#include "MathVector.h"
#include "constants.h"
#include "QC_Settings.h"
#include "LogManager.h"

extern LogManager logMgr;

class SecondPass
{
public:
   int individuals;
   int usableSamples;
   int currentMarker;
   
   String tag;
   
   int genotypeCounts;
   int mendelErrors;
   int mismatchErrors;
   int minorAlleleCount;
   int minorAllele;

   double logXOdds;
   double HWEPvalues;
   double mendelErrorRates;
   double maf;
   
   /*TDT related vars*/
   double T;
   double NT;
   double TDTChiSq;
   double TDTPvalue;
   int    completeTrios;
   char   alleles[2];
   
   /*Association test related variables*/
   double assocChiSq;
   double assocPvalue;
   int    numStrataTested;

   /*minimum and maximum statistic arrays*/
   Vector minimumStats;
   Vector maximumStats;
   
   /*failure summary variables */
   int minGenos;
   int minGenosFail;
   int HWEfail;
   int concordanceFail;
   int mendelFail;
   int mendelRateFail;
   int snpsNotAssessed;
   int minorAlleleFail;
   int mafFail;
   int failures;

   
   String failure;
   
   SecondPass();
   ~SecondPass();
   
   void Prepare(int markers, IntArray &mask);
   bool ProcessMarker(IntArray &genotypes, IntArray & sex, IntArray &mask, char* alleles, IntArray & isDuplicateSample, IntArray &fatherColumn, IntArray &motherColumn,bool isXLinked);
   bool PostProcess();
   void ConcordanceChecks(IntArray & genotypes, IntArray * duplicateSampleSets, int numSets);

   void XLinkedOdds(IntArray & genotypes, IntArray & sex, IntArray & mask, IntArray & isDuplicateSample, double errorRate);
   void SNPHWE(IntArray & genotypes, bool isSexLinked, IntArray & sexCodes, IntArray & mask, IntArray & fatherColumn, 
               IntArray & motherColumn, IntArray & isDuplicateSample);
   void TDTStatistic(IntArray & genotypes, IntArray & fatherColumn, IntArray & motherColumn, IntArray & mask, IntArray & sexCodes, IntArray & mendelErrors, 
                     IntArray & isDuplicateSample, bool isXLinked);
   void AssociationTest(IntArray &genotypes, IntArray &sampleLabels, IntArray &isDuplicateSample, IntArray & sexCodes, IntArray & mask, bool isSexLinked, int numLabels);
   
   void writeOutputHeader(FILE * markerFile, bool outTDT, bool outAssoc);
   void outputMarkerStatistics(FILE * markerFile, String & markerLabel, double avgQualityScore, bool outTDT, bool outAssoc);
   void outputNotAssessed(FILE * notAssessed, String & markerLabel, String failure);
   void writeOutputSummary();
   
   void UpdateLimits(double avgQualityScore);

   void ReleaseMemory();

   void setMendelErrors(int numberOfErrors, float mendelRate)
   {
      mendelErrors = numberOfErrors;
      mendelErrorRates = mendelRate;
   }

};

#endif
