#include "AxisLimits.h"

#include <math.h>

void AxisLimits::Adjust()
   {
   scale = 1.0;

   if (max - min == 0.0)
      return;

   if (min > max)
      {
      double swap = max;
      max = min;
      min = swap;
      }

   scale = pow(10, floor(log(max - min) / log(10.0) - 0.65));

   if ((max - min) / scale > 5)
      scale *= 2.0;

   if ((max - min) / scale > 5)
      scale *= 2.5;

   if ((max - min) / scale > 5)
      scale *= 2.0;

   char * units[] =  { "(* 1,000,000)", "", "(Thousands)", "(Millions)", "(Billions)", "(Trillions)" };
   double adjust[] = { 1e-6, 1.0, 1000, 1e6, 1e9, 1e12, 0.0 };
   double trips[] =  { 0.999e-6, 0.999e-3, 0.999e3, 0.999e6, 0.999e9, 0.999e12, 0.0 };

   for (int i = 0; trips[i] != 0.0; i++)
      if (scale >= trips[i])
         {
         scale_units = units[i];
         scale_adjust = adjust[i];
         }
   else
      break;

   if (scale > 1e15 || scale < 1e-15)
      {
      scale_adjust = pow(10, floor(log(scale) / log(10.0)));
      scale_units.printf("%.0e", 1/scale_adjust);
      }

   min = floor(min / scale + 0.0001) * scale;
   max = ceil(max / scale - 0.0001) * scale;
   }

int AxisLimits::TickCount()
   {
   int ticks = (int) ceil((max - min + scale * 0.5) / scale);

   return ticks;
   }

double AxisLimits::TickPosition(int n)
   {
   return min + scale * n;
   }

double AxisLimits::TickLabel(int n)
   {
   return (min + scale * n) / scale_adjust;
   }

int AxisLimits::Digits()
   {
   if (scale / scale_adjust > 1.0)
      return 0;

   return (int) (floor(-log(scale / scale_adjust) / log(10.0) + 0.8));
   }

double AxisLimits::Map(double value)
   {
   return (value - min) / (max - min + 1e-30);
   }


