#ifndef __AXISLIMITS_H__
#define __AXISLIMITS_H__

#include "StringBasics.h"

class AxisLimits
   {
   public:
      double min, max;

      double scale;
      String scale_units;
      double scale_adjust;

      AxisLimits(double minimum, double maximum)
         { Init(); min = minimum; max = maximum; }
      AxisLimits()
         { Init(); }

      void Adjust();

      int     TickCount();
      double  TickPosition(int n);
      double  TickLabel(int n);

      int     Digits();

      double  Map(double value);

   private:
      void Init()
         { min = 0.0; max = 1.0; scale = 1.0; };
   };

#endif


