#include "ChartLayout.h"

void ChartLayout::Layout(double x0, double y0, double x1, double y1)
   {
   ChartBox box(x0, y0, x1, y1);

   Layout(box);
   }

void ChartLayout::Layout(ChartBox & box)
   {
   box.SortCoordinates();

   double grid = box.Height() > box.Width() ? box.Height() / 20. : box.Width() / 20.;

   chartBox.x0() = box.x0() + grid * 3.00;
   if (!yLabel.IsEmpty() || !yAxis.scale_units.IsEmpty())
      chartBox.x0() += grid;

   chartBox.y0() = box.y0() + grid * 2.00;
   if (!xLabel.IsEmpty() || !xAxis.scale_units.IsEmpty())
      chartBox.y0() += grid;

   chartBox.y1() = box.y1() - grid * 1.00;
   if (!title.IsEmpty())
      chartBox.y1() -= grid * 1.90;

   chartBox.x1() = box.x1() - grid * 1.00;

   // Title size and location
   titleBox.x0() = chartBox.x0();
   titleBox.x1() = chartBox.x1();
   titleBox.y0() = chartBox.y1() + grid * 0.50;
   titleBox.y1() = chartBox.y1() + grid * 2.00;
   titleSize = grid * 1.0;

   // Axis label sizes and locations
   xLabelBox.x0() = chartBox.x0();
   xLabelBox.x1() = chartBox.x1();
   xLabelBox.y0() = chartBox.y0() - grid * 1.10;
   xLabelBox.y1() = chartBox.y0() - grid * 2.10;
   yLabelBox.x0() = chartBox.x0() - grid * 2.10;
   yLabelBox.x1() = chartBox.x0() - grid * 3.10;
   yLabelBox.y0() = chartBox.y0();
   yLabelBox.y1() = chartBox.y1();
   labelSize = grid * 0.90;

   // Tick label sizes and locations
   xTickLabelBox.x0() = chartBox.x0();
   xTickLabelBox.x1() = chartBox.x1();
   xTickLabelBox.y0() = chartBox.y0() - grid * 1.00;
   xTickLabelBox.y1() = chartBox.y0() - grid * 0.30;
   yTickLabelBox.x0() = chartBox.x0() - grid * 1.10;
   yTickLabelBox.x1() = chartBox.x0() - grid * 0.40;
   yTickLabelBox.y0() = chartBox.y0();
   yTickLabelBox.y1() = chartBox.y1();
   tickLabelSize = grid * 0.70;
   tickSize = grid * 0.30;

   // Unit positions
   xUnitBox = xLabelBox;
   xUnitBox.x0() += xLabelBox.Width() * 0.80;

   yUnitBox = yLabelBox;
   yUnitBox.y0() += yLabelBox.Height() * 0.80;

   unitLabelSize = grid * 0.50;

   layoutBox = box;
   }

double ChartLayout::MapX(double userX)
   {
   return xAxis.Map(userX) * chartBox.Width() + chartBox.x0();
   }

double ChartLayout::MapY(double userY)
   {
   return yAxis.Map(userY) * chartBox.Height() + chartBox.y0();
   }

