#ifndef __CHARTLAYOUT_H__
#define __CHARTLAYOUT_H__

#include "AxisLimits.h"
#include "ChartPoint.h"

class ChartLayout
   {
   public:
      AxisLimits  xAxis, yAxis;

      String title;
      String xLabel;
      String yLabel;

      ChartBox layoutBox;
      ChartBox chartBox;

      ChartBox titleBox;
      double   titleSize;

      ChartBox xLabelBox;
      ChartBox yLabelBox;
      double   labelSize;

      ChartBox xTickLabelBox;
      ChartBox yTickLabelBox;
      double   tickLabelSize;
      double   tickSize;

      ChartBox xUnitBox;
      ChartBox yUnitBox;
      double   unitLabelSize;

      void Layout(double x0, double y0, double x1, double y1);
      void Layout(ChartBox & box);

      double MapX(double userX);
      double MapY(double userY);

      ChartLayout()  {}
      ~ChartLayout() {}
   };

#endif


