#ifndef __CHARTPOINT_H__
#define __CHARTPOINT_H__

#include <math.h>

class ChartPoint
   {
   public:
      double x;
      double y;

      ChartPoint()
         { x = y = 0; }

      ChartPoint(double X, double Y)
         { x = X; y = Y; }

      void Set(double X, double Y)
         { x = X; y = Y; }
   };


class ChartBox
   {
   public:
      ChartPoint topRight;
      ChartPoint botLeft;

      ChartBox()
         { }

      ChartBox(double x0, double y0, double x1, double y1) :
         topRight(x0, y0), botLeft(x1, y1)
         { }

      double Height()  { return fabs(topRight.y - botLeft.y); }
      double Width()   { return fabs(topRight.x - botLeft.x); }

      double MiddleX() { return (topRight.x + botLeft.x) / 2.0; }
      double MiddleY() { return (topRight.y + botLeft.y) / 2.0; }

      double & x1() { return topRight.x; }
      double & y1() { return topRight.y; }
      double & x0() { return botLeft.x; }
      double & y0() { return botLeft.y; }

      void Set(double x0, double y0, double x1, double y1)
         {
         topRight.Set(x0, y0);
         botLeft.Set(x1, y1);
         }

      void SortCoordinates()
         {
         if (x0() > x1()) { double swap = x0(); x0() = x1(); x1() = swap; }
         if (y0() > y1()) { double swap = y0(); y0() = y1(); y1() = swap; }
         }
   };

#endif

