#include "PDFBarChart.h"

PDFBarChart::PDFBarChart()
   {
   yLabel = "Counts";
   counts = NULL;
   series = 0;
   }

PDFBarChart::~PDFBarChart()
   {
   if (counts != NULL) delete [] counts;
   }

void PDFBarChart::AllocateSeries(int seriesCount)
   {
   if (counts != NULL) delete [] counts;

   series = seriesCount;
   counts = new IntArray[series];

   red.Dimension(series);
   green.Dimension(series);
   blue.Dimension(series);

   for (int i = 0; i < series; i++)
      red[i] = green[i] = blue[i] = (i + 0.5) / series;
   }

void PDFBarChart::SetupBins(double minimum, double maximum, int observations, int maxBins)
   {
   if (series == 0)
      AllocateSeries(1);

   if (minimum == maximum)
      {
      bins = 0;
      return;
      }

   xAxis.min = minimum;
   xAxis.max = maximum;
   xAxis.Adjust();

   bins = 15;

   while ( fabs(maximum - minimum) / ((xAxis.max - xAxis.min) / bins) * observations > 30 &&
           bins < maxBins)
      bins *= 2;

   if (bins > maxBins)
      bins = maxBins > 0 ? maxBins : 10;

   for (int i = 0; i < series; i++)
      {
      counts[i].Dimension(bins);
      counts[i].Zero();
      }

   binWidth = (xAxis.max - xAxis.min) / bins;
   }

void PDFBarChart::Bin(int whatSeries, double value)
   {
   if (bins == 0) return;

   int bin = (int) ((value - xAxis.min) / binWidth);

   if (bin < 0) bin = 0;
   if (bin >= bins) bin = bins - 1;

   counts[whatSeries][bin]++;
   }

void PDFBarChart::Print(PDF & pdf)
   {
   yAxis.min = 0.0;
   yAxis.max = 1.0;

   for (int i = 0; i < bins; i++)
      {
      double sum = 0.0;

      for (int j = 0; j < series; j++)
         sum += counts[j][i];

      if (sum > yAxis.max)
         yAxis.max = sum;
      }
   yAxis.Adjust();

   PDFChartLayout::Print(pdf);

   for (int i = 0; i < bins; i++)
      {
      double binStart = MapX(xAxis.min + binWidth * i);
      double binEnd = MapX(xAxis.min + binWidth * (i + 1));

      double sum = 0.0;

      for (int j = 0; j < series; j++)
         if (counts[j][i])
            {
            double yStart = MapY(sum);
            double yEnd = MapY(sum += counts[j][i]);

//            if (series == 2)
               pdf.page.SetFillColor(red[j], green[j], blue[j]);

            pdf.page.Rectangle(binStart, yStart, binEnd, yEnd);
            }
      }
   }

