#ifndef __PDFBARCHART_H__
#define __PDFBARCHART_H__

#include "PDFChartLayout.h"
#include "MathVector.h"
#include "IntArray.h"

class PDFBarChart : public PDFChartLayout
   {
   public:
      IntArray * counts;
      int      series;

      PDFBarChart();
      ~PDFBarChart();

      void     AllocateSeries(int series);
      void     SetupBins(double minimum, double maximum, int observations, int maxBins = 100);

      void     Bin(int whatSeries, double value);
      void     Bin(double value) { Bin(0, value); }

      void     Print(PDF & pdf);

      Vector   red, green, blue;

   private:
      int      bins;
      double   binWidth;


   };

#endif


