#include "PDFChartLayout.h"

void PDFChartLayout::Print(PDF & pdf)
   {
   pdf.page.SetLineColor(0.0, 0.0, 0.0);
   pdf.page.SetFillColor(0.1, 0.1, 0.1);

   pdf.page.DrawRectangle(chartBox.x0(), chartBox.y0(), chartBox.x1(), chartBox.y1());

   pdf.page.hTextAlignment = taCenter;
   pdf.page.vTextAlignment = taMiddle;
   pdf.page.SetFont(fHelvetica, true, false);

   if (!title.IsEmpty())
      {
      pdf.page.SetFontSize(titleSize);
      pdf.page.WriteText(titleBox.MiddleX(), titleBox.MiddleY(), title);
      }

   if (!xLabel.IsEmpty())
      {
      pdf.page.SetFontSize(labelSize);
      pdf.page.WriteText(xLabelBox.MiddleX(), xLabelBox.MiddleY(), xLabel);
      }

   if (!yLabel.IsEmpty())
      {
      pdf.page.SetFontSize(labelSize);
      pdf.page.SetFontOrientation(90);
      pdf.page.WriteText(yLabelBox.MiddleX(), yLabelBox.MiddleY(), yLabel);
      pdf.page.SetFontOrientation(0);
      }

   pdf.page.SetFont(fHelvetica, false, false);

   if (!xAxis.scale_units.IsEmpty())
      {
      pdf.page.SetFontSize(unitLabelSize);
      pdf.page.WriteText(xUnitBox.MiddleX(), xUnitBox.MiddleY(), xAxis.scale_units);
      }

   if (!yAxis.scale_units.IsEmpty())
      {
      pdf.page.SetFontSize(unitLabelSize);
      pdf.page.SetFontOrientation(90);
      pdf.page.WriteText(yUnitBox.MiddleX(), yUnitBox.MiddleY(), yAxis.scale_units);
      pdf.page.SetFontOrientation(0);
      }

   String label;

   pdf.page.SetFontSize(tickLabelSize);

   for (int i = 0; i < xAxis.TickCount(); i++)
      {
      double userX = xAxis.TickPosition(i);
      double x = MapX(userX);

      label.printf("%.*f", xAxis.Digits(), xAxis.TickLabel(i));

      pdf.page.DrawLine(x, chartBox.y0(), x, chartBox.y0() - tickSize);
      pdf.page.WriteText(x, xTickLabelBox.MiddleY(), label);
      }

   pdf.page.hTextAlignment = taRight;
   for (int i = 0; i < yAxis.TickCount(); i++)
      {
      double userY = yAxis.TickPosition(i);
      double y = MapY(userY);

      label.printf("%.*f", yAxis.Digits(), yAxis.TickLabel(i));

      pdf.page.DrawLine(chartBox.x0(), y, chartBox.x0() - tickSize, y);
      pdf.page.WriteText(yTickLabelBox.x1(), y, label);
      }
   }

