#ifndef __PDFFONT_H__
#define __PDFFONT_H__

enum PDFFonts { fTimes = 0, fHelvetica = 1, fCourier = 2,
                fSymbol = 3, fZapfDingbats = 4 };

class PDF;

class PDFFont
   {
   private:
      static char * fontNames[14];
      static int  metrics[14][256];

      bool selectedFonts[14];
      int  fontDictionary;

      PDF & pdf;

   public:
      PDFFont(PDF & parent);

      // Functions for managing font dictionary
      void WriteResources();
      void WriteDictionary();
      void SelectFont(int fontid, double size);

      // Returns ID 0-14 for selected font
      int    GetFontID  (PDFFonts font, bool bold, bool italic );

      // Get Type 1 font name for a specific font
      char * GetFontName(PDFFonts font, bool bold, bool italic );
      char * GetFontName(int fontid);

      // Calculate width for a text string
      int  TextWidth(int font, const char * string);

      // Marks font for inclusion in font dictionary
      void MarkFont(int fontid);

   };

#endif


 
 
