 
#include "PDFinfo.h"
#include "PDF.h"

PDFInfo::PDFInfo()
   {
   time_t creation = time(NULL);
   tm * time_struct = gmtime(&creation);

   creationYear = time_struct->tm_year + 1900;
   creationMonth = time_struct->tm_mon + 1;
   creationDay = time_struct->tm_mday;

   creator = "A C++ PDF Library (c) 2001 Goncalo Abecasis";
   }

void PDFInfo::Write(PDF & pdf)
   {
   object = pdf.GetObject();

   pdf.OpenObject(object);
   pdf.OpenDictionary();

   if (!title.IsEmpty()) pdf.WriteString("Title", title);
   if (!author.IsEmpty()) pdf.WriteString("Author", author);
   if (!subject.IsEmpty()) pdf.WriteString("Subject", subject);
   if (!keywords.IsEmpty()) pdf.WriteString("Keywords", keywords);
   if (!producer.IsEmpty()) pdf.WriteString("Producer", producer);

   pdf.WriteString("Creator", creator);
   pdf.WriteDate("CreationDate", creationYear, creationMonth, creationDay);

   pdf.CloseDictionary();
   pdf.CloseObject();
   } 
 
 
