#ifndef __PEDDESCRIBE_H__
#define __PEDDESCRIBE_H__

#include "PedigreeGlobals.h"
#include "PedigreePerson.h"
#include "StringArray.h"
#include "IntArray.h"

#include <stdio.h>

// Possible pedigree columns
#define  pcSkip      0
#define  pcMarker    1
#define  pcTrait     2
#define  pcAffection 3
#define  pcCovariate 4
#define  pcZygosity  5
#define  pcEnd       6

class PedigreeDescription : public PedigreeGlobals
   {
   public:
      int      columnCount;
      IntArray columns, columnHash;

      PedigreeDescription();
      ~PedigreeDescription();

      void Load(FILE * Input);
      void Load(const char * filename);

      void LoadLinkageDataFile(FILE * input);
      void LoadLinkageDataFile(const char * filename);

      void LoadMendelDataFile(FILE * input);
      void LoadMendelDataFile(const char * filename);

      void LoadMap(FILE * Input);
      void LoadMap(const char * filename);

      PedigreeDescription & operator = (PedigreeDescription & rhs);

      int CountTextColumns();

      // returns a string summarizing column contents
      const char * ColumnSummary(String & string);

      // Flag specifying Mendel format
      bool mendelFormat;

   private:
      int ReadLineHelper(FILE * input, String & buffer, StringArray & tokens);

      int CountColumns(int type);
      void UpdateSummary(String & string, int type, const char * label);
   };

#endif

